echo off
REM #######################################
REM ## Script: Get HP array status info  ##
REM ## Version: 2                        ##
REM ## Writer: Jelle Stoel   ISSYS-ICT   ##
REM ## Date: may 2012                    ##
REM #######################################
Setlocal EnableDelayedExpansion
if "%1" == "" goto :EOF
set workdir=%~1
set hpacucli=%workdir%\hpacucli.exe
set outputhtml=%workdir%\output\array-status.html
set outputtxt=%workdir%\output\array-status.txt
set statusfile=%workdir%\output\array-status_events.txt
if exist "%outputhtml%" del /q "%outputhtml%"
if exist "%outputtxt%" del /q "%outputtxt%"
if exist "%statusfile%" del /q "%statusfile%"

call :title "HP array controller overview
call :header "Controller health status"

for /f "tokens=1* delims=]" %%a in ('%hpacucli% ctrl all show status ^| find /n /v ""') do (
@echo %%b ^</br^> >> %outputhtml%
@echo ^> %%b >> %outputtxt%
)


call :header "Controller config brief"
for /f "tokens=1* delims=]" %%a in ('%hpacucli% ctrl all show config ^| find /n /v ""') do (
echo "%%b" | findstr "Failed Rebuilding Recovering"
if "!errorlevel!" == "1" @echo %%b ^</br^> >> %outputhtml%
if "!errorlevel!" == "0" (
@echo ^<span style="color: red;"^>%%b^</span^> ^</br^> >> %outputhtml%
@echo %%b>>%statusfile%
)
@echo ^> %%b >> %outputtxt%
)
call :header "Controller config detailed"
for /f "tokens=1* delims=]" %%a in ('%hpacucli% ctrl all show config detail ^| find /n /v ""') do (
@echo %%b ^</br^> >> %outputhtml%
@echo ^> %%b >> %outputtxt%
)
goto :EOF
:header
echo ^<h2^>%~1^</h2^> >> %outputhtml%
call :break
goto :EOF
:title
echo ^<h1^>%~1^</h1^> > %outputhtml%
call :break
call :break
goto :EOF
:break
echo ^</br^> >> %outputhtml%
goto :EOF